<?php
include '../include/session.php'; 
$page='user';
?>
<!DOCTYPE html>
<html lang="en">

<?php
    include '../include/header.php'; 
?>

<body id="page-top" style="font-family: 'Prompt', sans-serif;">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php include '../menu/side_menu.php'; ?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <?php include '../menu/topbar_menu.php'; ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">

                    <!-- Page Heading -->
                    <h1 class="h3 mb-2 text-gray-800">จัดการลูกค้า</h1>
                    <p class="mb-4"></p>
                    <?php
                            if(isset($_SESSION['error'])){
                              echo "
                                <div class='alert alert-danger alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-warning'></i> Error!</h4>
                                  ".$_SESSION['error']."
                                </div>
                              ";
                              unset($_SESSION['error']);
                            }
                            if(isset($_SESSION['success'])){
                              echo "
                                <div class='alert alert-success alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-check'></i> Success!</h4>
                                  ".$_SESSION['success']."
                                </div>
                              ";
                              unset($_SESSION['success']);
                            }
                ?>
                    <!-- DataTales Example -->

                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">จัดการลูกค้าและแอดมิน</h6>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="user.php">

                                <div class="form-row">

                                    <div class="form-group col-md-2">
                                          <label for="fromdate">วันที่ :</label>
                                              
                                            <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['fromdate']!='') {
                                                  $fromdate=$_POST['fromdate'];
                                                }else{
                                                  $fromdate=date('Y-m-01',strtotime("-1 year"));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="fromdate" id="fromdate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $fromdate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#fromdate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                        <div class="form-group col-md-2">
                                          <label for="todate">ถึงวันที่ :</label>
                                              
                                             <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['todate']!='') {
                                                  $todate=$_POST['todate'];
                                                }else{
                                                $a_date = date('Y-m-01');
                                                  $todate=date("Y-m-t", strtotime($a_date));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="todate" id="todate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $todate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#todate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                    </div>    
                                    <center>    
                                    <button type="submit" class="btn btn-primary btn-user " name="search"><i class="fa fa-search"></i> ค้นหา</button>

                                     <a  href="#" data-toggle="modal" data-target="#adduserModal">
                                    <button   class="btn btn-success btn-user "><i class="fa fa-plus"></i> เพิ่มลูกค้าใหม่</button>
                                </a>


                                    </center>

                            </form>
                        </div>
                    </div>
                    <div class="card shadow mb-4">
                        
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0" style="font-size: 12px;" data-order='[[ 0, "desc" ]]'>
                                    <thead>
                                        <tr>
                                            <th>วันที่เข้าระบบ</th>
                                            <th>ประเภทผู้ใช้</th>
                                            <th>รหัสลูกค้า</th>
                                            <th>ชื่อลูกค้า</th>
                                            <th>ที่อยู่</th>
                                            <th>เบอร์โทร</th>
                                            <th>ประเภทลูกค้า</th>
                                            <th>ประเภทการจัดส่ง</th>
                                            <th>ขนส่ง</th>
                                            
                                            <th>#</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>วันที่เข้าระบบ</th>
                                            <th>ประเภทผู้ใช้</th>
                                            <th>รหัสลูกค้า</th>
                                            <th>ชื่อลูกค้า</th>
                                            <th>ที่อยู่</th>
                                            <th>เบอร์โทร</th>
                                            <th>ประเภทลูกค้า</th>
                                            <th>ประเภทการจัดส่ง</th>
                                            <th>ขนส่ง</th>
                                            
                                            <th>#</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                       
                                        <?php
                                                $conn = $pdo->open();
                                                try{
                                                  $stmt = $conn->prepare("
                                                     SELECT
                                                            `user`.user_id,
                                                            `user`.user_code,
                                                            `user`.user_name,
                                                            user_type.user_type_name,
                                                            `user`.user_address,
                                                            `user`.user_tel,
                                                            user_customer_type.user_customer_type_name,
                                                            user_delivery_type.user_delivery_type_name,
                                                            user_delivery_vendor.user_delivery_vendor_name,
                                                            `user`.user_adddate,
                                                            `user`.user_addby
                                                            FROM
                                                            `user`
                                                            LEFT JOIN user_customer_type ON user_customer_type.user_customer_type_id = `user`.user_customer_type_id
                                                            LEFT JOIN user_type ON user_type.user_type_id = `user`.user_type_id
                                                            LEFT JOIN user_delivery_type ON user_delivery_type.user_delivery_type_id = `user`.user_delivery_type_id
                                                            LEFT JOIN user_delivery_vendor ON user_delivery_vendor.user_delivery_vendor_id = `user`.user_delivery_vendor_id

                                                            where 1=1
                                                            and user_adddate BETWEEN  :fromdate AND :todate   

                                                            ORDER BY
                                                            `user`.user_id ASC
                                                    ");
                                                  $stmt->execute(['fromdate'=>$fromdate,'todate'=>$todate]);
                                                foreach($stmt as $row){
                                                    echo "
                                                          <tr>
                                                          <td >".$row['user_adddate']."</td>
                                                          <td >".$row['user_type_name']."</td> 
                                                          <td >".$row['user_code']."</td>
                                                          <td >".$row['user_name']."</td>
                                                          <td >".$row['user_address']."</td>
                                                          <td >".$row['user_tel']."</td>
                                                          
                                                          
                                                          
                                                          <td >".$row['user_customer_type_name']."</td>
                                                          <td >".$row['user_delivery_type_name']."</td>
                                                          <td >".$row['user_delivery_vendor_name']."</td>

                                                          


                                                            <td>
                                                              <button class='btn btn-success btn-sm edit btn-flat' data-id='".$row['user_id']."'><i class='fa fa-edit'></i> แก้ไข</button>
                                                              <button class='btn btn-danger btn-sm delete btn-flat' data-id='".$row['user_id']."'><i class='fa fa-trash'></i> ลบ</button>
                                                            </td>
                                                          </tr>
                                                        ";
                                                    }
                                                }
                                                catch(PDOException $e){
                                                  echo $e->getMessage();
                                                }
                                        ?>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; THANAPHONG +66968232815</span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <?php include 'user_add_modal.php'; ?>
    <?php include 'user_delete_modal.php'; ?>    
    <?php include 'user_edit_modal.php'; ?> 
    <?php include '../authen/logout_modal.php'; ?>
    <?php include '../include/script.php'; ?>
    


    <script>
$(function(){
  

  $(document).on('click', '.delete', function(e){
    e.preventDefault();
    $('#deleteuserModal').modal('show');
    var id = $(this).data('id');
    getRow(id);
  });

$(document).on('click', '.edit', function(e){
    e.preventDefault();
    $('#edituserModal').modal('show');
    var id = $(this).data('id');
    getRow(id);
  });

});

function getRow(id){
  $.ajax({
    type: 'POST',
    url: 'user_row.php',
    data: {id:id},
    dataType: 'json',
    success: function(response){
      $('.id').val(response.user_id);
      $('.name').html(response.user_name);

      $('#edit_user_code').val(response.user_code);
      $('#edit_user_name').val(response.user_name);
      $('#edit_user_address').val(response.user_address);
      $('#edit_user_tel').val(response.user_tel);
      $('#edit_user_username').val(response.user_username);
      $('#edit_user_password').val(response.user_password);

      $('#user_type_id_selected').val(response.user_type_id).html(response.user_type_name);
      $('#user_customer_type_id_selected').val(response.user_customer_type_id).html(response.user_customer_type_name);
      $('#user_delivery_type_id_selected').val(response.user_delivery_type_id).html(response.user_delivery_type_name);
      $('#user_delivery_vendor_id_selected').val(response.user_delivery_vendor_id).html(response.user_delivery_vendor_name);
      


    }
  });




}
</script>


</body>

</html>