<?php
include '../include/session.php'; 
$page='container_ceo';
?>
<!DOCTYPE html>
<html lang="en">

<?php
    include '../include/header.php'; 
?>

<body id="page-top" style="font-family: 'Prompt', sans-serif;">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php include '../menu/side_menu.php'; ?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <?php include '../menu/topbar_menu.php'; ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">

                    <!-- Page Heading -->
                    <h1 class="h3 mb-2 text-gray-800">จัดการตู้สินค้า CEO</h1>
                    <p class="mb-4"></p>
                    <?php
                            if(isset($_SESSION['error'])){
                              echo "
                                <div class='alert alert-danger alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-warning'></i> Error!</h4>
                                  ".$_SESSION['error']."
                                </div>
                              ";
                              unset($_SESSION['error']);
                            }
                            if(isset($_SESSION['success'])){
                              echo "
                                <div class='alert alert-success alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-check'></i> Success!</h4>
                                  ".$_SESSION['success']."
                                </div>
                              ";
                              unset($_SESSION['success']);
                            }
                ?>
                    <!-- DataTales Example -->

                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">จัดการตู้สินค้า CEO</h6>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="container_ceo.php">

                                <div class="form-row">

                                    <div class="form-group col-md-2">
                                          <label for="fromdate">วันที่ :</label>
                                              
                                            <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['fromdate']!='') {
                                                  $fromdate=$_POST['fromdate'];
                                                }else{
                                                  $fromdate=date('Y-m-01',strtotime("-1 year"));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="fromdate" id="fromdate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $fromdate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#fromdate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                        <div class="form-group col-md-2">
                                          <label for="todate">ถึงวันที่ :</label>
                                              
                                             <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['todate']!='') {
                                                  $todate=$_POST['todate'];
                                                }else{
                                                $a_date = date('Y-m-01');
                                                  $todate=date("Y-m-t", strtotime($a_date));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="todate" id="todate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $todate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#todate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                    </div>    
                                    <center>    
                                    <button type="submit" class="btn btn-primary btn-user " name="search"><i class="fa fa-search"></i> ค้นหา</button>

                                     <a  href="#" data-toggle="modal" data-target="#adduserModal">
                                    <button   class="btn btn-success btn-user "><i class="fa fa-plus"></i> เพิ่มตู้ใหม่</button>
                                </a>


                                    </center>

                            </form>
                        </div>
                    </div>
                    <div class="card shadow mb-4">
                        
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0" style="font-size: 12px;" data-order='[[ 0, "desc" ]]'>
                                    <thead>
                                        <tr>
                                             <th>วันที่สร้างรายการ</th>
                                            <th>หมายเลขตู้</th>
                                            <th>มาจาก</th>
                                            <th>EK/SEA</th>
                                            <th>ค่าตู้</th>
                                            <th>สถานะตู้</th>
                                            <th>ยอดทั้งหมด</th>
                                            <th>รอวางบิล</th>
                                            <th>รอชำระเงิน</th>
                                            <th>ชำระแล้ว</th>
                                            <th>กำไร</th>
                                            <th>ราคาตู้จีน</th>
                                            <th>ราคาตู้ไทย</th>
                                            <th>กำไรใหม่</th>
                                            <th>#</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                             <th>วันที่สร้างรายการ</th>
                                            <th>หมายเลขตู้</th>
                                            <th>มาจาก</th>
                                            <th>EK/SEA</th>
                                            <th>ค่าตู้</th>
                                            <th>สถานะตู้</th>
                                            <th>ยอดทั้งหมด</th>
                                            <th>รอวางบิล</th>
                                            <th>รอชำระเงิน</th>
                                            <th>ชำระแล้ว</th>
                                            <th>กำไร</th>
                                            <th>ราคาตู้จีน</th>
                                            <th>ราคาตู้ไทย</th>
                                            <th>กำไรใหม่</th>
                                            <th>#</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                       
                                        <?php
                                                $conn = $pdo->open();
                                                try{
                                                  $stmt = $conn->prepare("
                                                      SELECT
                                                          container.container_id,
                                                          container.container_no,
                                                          container.container_travel_date,
                                                          container.container_forcast_date,
                                                          container.container_type,
                                                          container.container_from,
                                                          container.container_cost,
                                                          container.container_status,
                                                          container.container_active,
                                                          container.container_add_by,
                                                          container.container_add_date,
                                                          container.container_file_status,
                                                          container.container_file_type,    
                                                          container_status.container_status_name,
                                                          container_status.container_status_color,
                                                          Sum(orders.order_product_price) AS sum_price,
                                                          Sum(orders.order_product_cost) AS sum_cost,
                                                          SUM(CASE WHEN orders.order_billing_status = 3 THEN orders.order_product_price END) as paid_price,
                                                          SUM(CASE WHEN orders.order_billing_status = 2 THEN orders.order_product_price END) as wait_price,
                                                          SUM(CASE WHEN orders.order_billing_status = 1 THEN orders.order_product_price END) as pending_price
                                                          FROM
                                                          container
                                                          LEFT JOIN container_status ON container_status.container_status_id = container.container_status
                                                          LEFT JOIN orders ON orders.order_container_id = container.container_id

                                                            where 1=1
                                                            and container_add_date BETWEEN  :fromdate AND :todate   
                                                          GROUP BY container.container_id  
                                                          
                                                    ");
                                                  $stmt->execute(['fromdate'=>$fromdate,'todate'=>$todate]);
                                                foreach($stmt as $row){
                                                    $profit=$row['sum_price']-$row['sum_cost'];

                                                    if ($row['container_file_status']==1) {
                                                     $file_check = "<a href='../../file_upload/thai_container_excel/".$row['container_id'].".".$row['container_file_type']."'><button class='btn btn-primary  btn-sm  btn-flat' data-id='".$row['container_id']."'><i class='fa fa-download'></i></button></a>";
                                                    }else{
                                                      $file_check = "";
                                                    }

                         


                          $status='<label class="bg-'.$row['container_status_color'].' text-white">'.$row['container_status_name'].'</label>';
                        echo "
                          <tr>
                          <td >".$row['container_add_date']."</td> 

                          <td >".$row['container_no']."</td>

                          <td >".$row['container_from']."</td>
                          <td >".$row['container_type']."</td>
                          <td >".number_format($row['sum_cost'],2)."</td>
                          <td >".$status."</td>  

                          

                          <td ><a href='../order/order.php?container_id=".$row['container_id']."&fromdate=".$row['container_add_date']."&todate=".$row['container_add_date']."&search='>".number_format($row['sum_price'],2)."</a></td>

                          <td ><a href='../order/order.php?container_id=".$row['container_id']."&fromdate=".$row['container_add_date']."&todate=".$row['container_add_date']."&order_billing_status=1&search='>".number_format($row['pending_price'],2)."</a></td>

                          <td ><a href='../order/order.php?container_id=".$row['container_id']."&fromdate=".$row['container_add_date']."&todate=".$row['container_add_date']."&order_billing_status=2&search='>".number_format($row['wait_price'],2)."</a></td>

                          <td ><a href='../order/order.php?container_id=".$row['container_id']."&fromdate=".$row['container_add_date']."&todate=".$row['container_add_date']."&order_billing_status=3&search='>".number_format($row['paid_price'],2)."</a></td>

                         
                            <td>".number_format($profit,2)."</td>
                         <td>".number_format($row['container_china_price'],2)."</td>
                         <td>".number_format($row['container_thai_price'],2)."</td>
                         <td>".number_format($profit2,2)."</td>
                        


                            <td>
                              <button class='btn btn-success btn-sm edit btn-flat' data-id='".$row['container_id']."'><i class='fa fa-edit'></i></button>
                              <button class='btn btn-danger btn-sm delete btn-flat' data-id='".$row['container_id']."'><i class='fa fa-trash'></i></button>
                              ".$file_check."
                            </td>
                          </tr>
                        ";
                                                    }
                                                }
                                                catch(PDOException $e){
                                                  echo $e->getMessage();
                                                }
                                        ?>
                                       
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; THANAPHONG +66968232815</span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <?php include 'container_ceo_add_modal.php'; ?>
    <?php include 'container_ceo_delete_modal.php'; ?>    
    <?php include 'container_ceo_edit_modal.php'; ?> 
    <?php include '../authen/logout_modal.php'; ?>
    <?php include '../include/script.php'; ?>
    


  <script>

            $(document).ready(function() {
    $('#dataTable_order').DataTable( {
        "order": [[ 0, "desc" ]]
    } );
} );

            
$(function(){
  
 


 


  $(document).on('click', '.delete', function(e){
    e.preventDefault();
    $('#deleteuserModal').modal('show');
    var id = $(this).data('id');
    getRow(id);
  });

$(document).on('click', '.edit', function(e){
    e.preventDefault();
    $('#edituserModal').modal('show');
    var id = $(this).data('id');
    getRow(id);
  });

});

function getRow(id){
  $.ajax({
    type: 'POST',
    url: 'container_ceo_row.php',
    data: {id:id},
    dataType: 'json',
    success: function(response){
      $('.id').val(response.container_id);
      $('.name').html(response.container_no);

      $('#edit_container_no').val(response.container_no);
      $('#edit_container_type').val(response.container_type);
      $('#edit_container_from').val(response.container_from);
      $('#edit_container_cost').val(response.container_cost);
      $('#edit_container_travel_date').val(response.container_travel_date);
      $('#edit_container_forcast_date').val(response.container_forcast_date);
      $('#edit_container_add_date').val(response.container_add_date);
      $('#edit_container_china_price').val(response.container_china_price);
      $('#edit_container_thai_price').val(response.container_thai_price);
 




    }
  });




}
</script>


</body>

</html>