<?php
include '../include/session.php'; 
include '../../include/conn.php'; 
$page='employee';
$menu_id='3';
?>
<!DOCTYPE html>
<html lang="en">

<?php
    include '../include/header.php'; 
?>

<body id="page-top" style="font-family: 'Prompt', sans-serif;">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php include '../menu/side_menu.php'; ?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <?php include '../menu/topbar_menu.php'; ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">

                    <!-- Page Heading -->
                    <h1 class="h3 mb-2 text-gray-800">จัดการแผนก</h1>
                    <p class="mb-4"></p>
                    <?php
                            if(isset($_SESSION['error'])){
                              echo "
                                <div class='alert alert-danger alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-warning'></i> Error!</h4>
                                  ".$_SESSION['error']."
                                </div>
                              ";
                              unset($_SESSION['error']);
                            }
                            if(isset($_SESSION['success'])){
                              echo "
                                <div class='alert alert-success alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-check'></i> Success!</h4>
                                  ".$_SESSION['success']."
                                </div>
                              ";
                              unset($_SESSION['success']);
                            }
                ?>
                    <!-- DataTales Example -->

                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">จัดการแผนก</h6>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="user.php">

                                <div class="form-row">

                                    <div class="form-group col-md-2">
                                          <label for="fromdate">วันที่ :</label>
                                              
                                            <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['fromdate']!='') {
                                                  $fromdate=$_POST['fromdate'];
                                                }else{
                                                  $fromdate=date('Y-m-01',strtotime("-1 year"));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="fromdate" id="fromdate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $fromdate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#fromdate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                        <div class="form-group col-md-2">
                                          <label for="todate">ถึงวันที่ :</label>
                                              
                                             <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['todate']!='') {
                                                  $todate=$_POST['todate'];
                                                }else{
                                                $a_date = date('Y-m-01');
                                                  $todate=date("Y-m-t", strtotime($a_date));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="todate" id="todate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $todate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#todate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                    </div>    
                                    <center>    
                                    <button type="submit" class="btn btn-primary btn-user " name="search"><i class="fa fa-search"></i> ค้นหา</button>

                                     <a  href="#" data-toggle="modal" data-target="#adduserModal">
                                    <button   class="btn btn-success btn-user "><i class="fa fa-plus"></i> เพิ่มพนักงานใหม่</button>
                                </a>


                                    </center>

                            </form>
                        </div>
                    </div>
                    <div class="card shadow mb-4">
                        
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0" style="font-size: 12px;" data-order='[[ 2, "desc" ]]'>
                                    <thead>
                                        <tr>
                                          <th>#</th>
                                            <th>ชื่อแผนก</th>
                                            <th>สถานะ</th>
                                            <th>#</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                          <th>#</th>
                                            <th>ชื่อแผนก</th>
                                            <th>สถานะ</th>
                                            <th>#</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                       
                                        <?php
                                                $conn = $pdo->open();
                                                try{
                                                  $stmt = $conn->prepare("
                                                   
SELECT
    depart.depart_name, 
    depart.depart_id, 
    depart.depart_status
FROM
    depart

 where 1=1
                                                       
                                                 

                                                           
                                                    ");
                                                  $stmt->execute(['fromdate'=>$fromdate,'todate'=>$todate]);
                                                foreach($stmt as $row){

                                                   

                                                    switch ($row['depart_status']) {
                                                        case 1:$active = "<a class='badge badge-success '  data-id='".$row['depart_id']."'>เปิดใช้งาน</a>";break;
                                                        default :$active = "<a class='badge badge-danger '  data-id='".$row['depart_id']."'>ปิดใช้งาน</a>";break;
                                                    }

                                                    echo "
                                                          <tr>
                                                          <td >".$row['depart_id']."</td>
                                                          <td >".$row['depart_name']."</td>
                                                          <td >".$active."</td>

                                                          


                                                            <td>
                                                              <button class='btn btn-success btn-sm edit btn-flat' data-id='".$row['depart_id']."'><i class='fa fa-edit'></i> แก้ไข</button>
                                                            </td>
                                                          </tr>
                                                        ";
                                                    }
                                                }
                                                catch(PDOException $e){
                                                  echo $e->getMessage();
                                                }
                                        ?>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; THANAPHONG +66968232815</span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <?php include 'depart_add_modal.php'; ?>
    <?php include 'depart_delete_modal.php'; ?>    
    <?php include 'depart_edit_modal.php'; ?> 
    <?php include '../authen/logout_modal.php'; ?>
    <?php include '../include/script.php'; ?>
    


    <script>
$(function(){
  

  $(document).on('click', '.delete', function(e){
    e.preventDefault();
    $('#deleteuserModal').modal('show');
    var id = $(this).data('id');
    getRow(id);
  });

$(document).on('click', '.edit', function(e){
    e.preventDefault();
    $('#edituserModal').modal('show');
    var id = $(this).data('id');
    getRowEdit(id);
  });

});

function getRow(id){
  $.ajax({
    type: 'POST',
    url: 'user_row.php',
    data: {id:id},
    dataType: 'json',
    success: function(response){
      $('.id').val(response.user_id);
      $('.name').html(response.user_name);

      
  
      $('#user_unactive_selected').val(response.user_active).html(response.user_active_value);


    }
  });




}

function getRowEdit(id){
  $.ajax({
    type: 'POST',
    url: 'depart_row_edit.php',
    data: {id:id},
    dataType: 'json',
    success: function(response){
      $('#depart_id_edit').val(response.depart_id);
      $('#depart_name_edit').val(response.depart_name);






    }
  });




}
</script>


</body>

</html>