<?php
include '../include/session.php'; 
include '../../include/conn.php'; 
$page='maintenance';
?>
<!DOCTYPE html>
<html lang="en">

<?php
    include '../include/header.php'; 
?>

<body id="page-top" style="font-family: 'Prompt', sans-serif;">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php include '../menu/side_menu.php'; ?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <?php include '../menu/topbar_menu.php'; ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">

                    <!-- Page Heading -->
                    <h1 class="h3 mb-2 text-gray-800">จัดการการเบิกน้ำมัน</h1>
                    <p class="mb-4"></p>
                    <?php
                            if(isset($_SESSION['error'])){
                              echo "
                                <div class='alert alert-danger alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-warning'></i> Error!</h4>
                                  ".$_SESSION['error']."
                                </div>
                              ";
                              unset($_SESSION['error']);
                            }
                            if(isset($_SESSION['success'])){
                              echo "
                                <div class='alert alert-success alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-check'></i> Success!</h4>
                                  ".$_SESSION['success']."
                                </div>
                              ";
                              unset($_SESSION['success']);
                            }
                ?>
                    <!-- DataTales Example -->

                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">จัดการการเบิกน้ำมัน

                            <a  href="fuel_add.php" >
                                    <button   class="btn btn-info btn-user btn-sm    "><i class="fa fa-plus"></i> เบิกน้ำมัน</button>
                                </a>

                             <a  href="maintenance_update_complete_job.php" >
                                    <button   class="btn btn-success btn-user btn-sm    "><i class="fa fa-check"></i> ส่งงาน</button>
                                </a>

                            </h6>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="maintenance.php">

                                <div class="form-row">

                                    <div class="form-group col-md-2">
                                          <label for="fromdate">วันที่ :</label>
                                              
                                            <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['fromdate']!='') {
                                                  $fromdate=$_POST['fromdate'];
                                                }else{
                                                  $fromdate=date('Y-m-01',strtotime("-1 year"));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="fromdate" id="fromdate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $fromdate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#fromdate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                        <div class="form-group col-md-2">
                                          <label for="todate">ถึงวันที่ :</label>
                                              
                                             <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['todate']!='') {
                                                  $todate=$_POST['todate'];
                                                }else{
                                                $a_date = date('Y-m-01');
                                                  $todate=date("Y-m-t", strtotime($a_date));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="todate" id="todate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $todate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#todate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>


                                        <div class="form-group col-md-2">
                                          <label for="maintenance_depart_id">ส่วนงาน</label>
                                            <select class="form-control "  name="maintenance_depart_id" id="maintenance_depart_id"  >
                                             
                                               <option value="">ทั้งหมด</option>

                                                <?php



                    $conn = $pdo->open();

                    try{
                      $stmt = $conn->prepare("
SELECT
    maintenance_depart.maintenance_depart_id, 
    maintenance_depart.maintenance_depart_name
FROM
    maintenance_depart

                        ");
                       
                      echo $stmt->execute([]);

                      foreach($stmt as $row){

                         
                        echo "
                          <option value='".$row['maintenance_depart_id']."'>".$row['maintenance_depart_name']."</option>
                        ";
                      }
                    }
                    catch(PDOException $e){
                      echo $e->getMessage();
                    }

                    $pdo->close();



                                            ?>




                                            </select>
                                        </div>


                                        

                                    </div>    
                                    <center>    
                                    <button type="submit" class="btn btn-primary btn-user " name="search"><i class="fa fa-search"></i> ค้นหา</button>

                                     
                                    </center>

                            </form>
                                <center> 
                            
                                 </center>
                        </div>
                    </div>
                    <div class="card shadow mb-4">
                        
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0" style="font-size: 14px;" data-order='[[ 0, "desc" ]]'>
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>วันที่เติม</th>
                                            <th>ทะเบียน</th>
                                            <th>เลขไมล์</th>
                                            <th>เติมจาก</th>
                                            <th>จำนวนลิตร</th>
                                            <th>#</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>#</th>
                                            <th>วันที่เติม</th>
                                            <th>ทะเบียน</th>
                                            <th>เลขไมล์</th>
                                            <th>เติมจาก</th>
                                            <th>จำนวนลิตร</th>
                                            <th>#</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                       
                                        <?php
                                                $conn = $pdo->open();
                                                try{
                                                  $stmt = $conn->prepare("
                                                   


SELECT
    vehicle.vehicle_plate_no,
    vehicle.vehicle_no,
    fu_fuel_data_log.fuel_data_log_vehicle_mileage_old,
    fu_fuel_data_log.fuel_data_log_vehicle_mileage_current,
    fu_fuel_data_log.fuel_data_log_fuel_amount,
    fu_fuel_data_log.fuel_data_log_fill_date,
    fu_fuel_data_log.fuel_data_log_active,
    fu_fuel_data_log.fuel_vehicle_consumption_rate,
    vehicle.vehicle_consumption_rate,
    fu_fuel_data_log.fuel_data_log_add_date,
    fu_fuel_data_log.fuel_data_log_id,
    fu_tank.tank_name
FROM
    fu_fuel_data_log
    LEFT JOIN fu_tank ON fu_fuel_data_log.fuel_data_log_tank_id = fu_tank.tank_id
    LEFT JOIN vehicle ON fu_fuel_data_log.fuel_data_log_vehicle_id = vehicle.vehicle_id
 where 1=1
                                                            and fuel_data_log_add_date BETWEEN  :fromdate AND :todate  

                                                           
                                                    ");

                                                 


                                                  $stmt->execute(['fromdate'=>$fromdate,'todate'=>$todate]);
                                                foreach($stmt as $row){

                                                   $maintenance_add_date = strtotime($row['maintenance_add_date']); 
                                                   $maintenance_add_date = date('d/m/Y H:i:s', $maintenance_add_date);

                                                    if ($row['fuel_data_log_fill_date']!="1970-01-01 00:00:00") {
                                                       $fuel_data_log_fill_date = strtotime($row['fuel_data_log_fill_date']); 
                                                        $fuel_data_log_fill_date = date('d/m/Y', $fuel_data_log_fill_date);
                                                   }else{
                                                        $fuel_data_log_fill_date = "";
                                                   }


                                                   if ($row['maintenance_fix_completed_date']!="1970-01-01 00:00:00") {
                                                       $maintenance_fix_completed_date = strtotime($row['maintenance_fix_completed_date']); 
                                                       $maintenance_fix_completed_date = date('d/m/Y', $maintenance_fix_completed_date);
                                                   }else{
                                                        $maintenance_fix_completed_date = "";
                                                   }

                                                   $maintenance_status='<label class="bg-'.$row['maintenance_status_color'].' text-white">'.$row['maintenance_status_name'].'</label>';



                                                    echo "
                                                          <tr>
                                                          <td >".$row['fuel_data_log_id']."</td>
                                                          <td >".$fuel_data_log_fill_date."</td>
                                                          <td >".$row['vehicle_plate_no']."</td>
                                                          <td >".$row['fuel_data_log_vehicle_mileage_current']."</td>
                                                          <td >".$row['tank_name']."</td>
                                                          <td >".$row['fuel_data_log_fuel_amount']."</td>
                                                         




                                                            <td>
                                                            <a href=maintenance_edit.php?maintenance_id=".$row['maintenance_id'].">
                                                              <button class='btn btn-success btn-sm  btn-flat' ><i class='fa fa-edit'></i> แก้ไข</button>
                                                            </a>
                                                            </td>
                                                          </tr>
                                                        ";
                                                    }
                                                }
                                                catch(PDOException $e){
                                                  echo $e->getMessage();
                                                }
                                        ?>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; THANAPHONG +66968232815</span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

   
    <?php include '../authen/logout_modal.php'; ?>
    <?php include '../include/script.php'; ?>
    


   


</body>

</html>