<?php

include '../include/session.php';
include '../../include/conn.php';
require ('../../include/fpdf/fpdf.php');

$pdf = new FPDF('P');

$start_date = $_GET['fromdate'];
$end_date = $_GET['todate'];
$i = 1;
$user_name = $_GET['user_name'];
$employee_type_id = $_GET['employee_type_id'];

if ($user_name!='') {
    $filter_user_name="AND user_name like CONCAT('%',:user_name,'%')";
}else{
    $filter_user_name="";
}

$thai_day_arr = array(
    "อาทิตย์",
    "จันทร์",
    "อังคาร",
    "พุธ",
    "พฤหัสบดี",
    "ศุกร์",
    "เสาร์"
);
$thai_month_arr = array(
    "0" => "",
    "1" => "มกราคม",
    "2" => "กุมภาพันธ์",
    "3" => "มีนาคม",
    "4" => "เมษายน",
    "5" => "พฤษภาคม",
    "6" => "มิถุนายน",
    "7" => "กรกฎาคม",
    "8" => "สิงหาคม",
    "9" => "กันยายน",
    "10" => "ตุลาคม",
    "11" => "พฤศจิกายน",
    "12" => "ธันวาคม"
);
function thai_date($time)
{
    global $thai_day_arr, $thai_month_arr;
    $thai_date_return = $thai_day_arr[date("w", $time) ];
    return $thai_date_return;
}

$conn = $pdo->open();
try
{

    $stmt = $conn->prepare("
    SELECT `user`.user_code,
    `user`.user_name,
    `user`.user_nick_name,
    `user`.user_id,
    depart.depart_name,
    branch.branch_id,
    branch.branch_name 
    FROM `user` 
    LEFT JOIN depart ON `user`.user_depart_id = depart.depart_id 
    LEFT JOIN employee_type ON `user`.user_employee_type_id = employee_type.employee_type_id
     LEFT JOIN branch ON `user`.user_branch_id = branch.branch_id 
    WHERE 1=1 
     and `user`.user_type_id != 3
    AND user.user_active != '99'
    ".$filter_user_name."
    ORDER BY `user`.user_depart_id DESC
  
    ");

    $stmt->execute([
        'user_name' => $user_name,
   ]);

    foreach ($stmt as $row)
    {   
        $sum_sick_leave=0;
        $sum_holiday_leave=0;
        $sum_personal_leave=0;
        $sum_late=0;
        $sum_ot=0;
        $i = 1;
        $user_id_set = $row['user_id'];

        $pdf->AddPage();
        $pdf->AddFont('angsa', '', 'angsa.php');
        $pdf->SetFont('angsa', '', 20);
        $pdf->Cell(0, 5, iconv('UTF-8', 'TIS-620', 'รายงานการลงเวลาทำงานพนักงาน') , 0, 1, "C");
        $pdf->Cell(0, 10, iconv('UTF-8', 'TIS-620', 'RUNGJARIN AIRBUS') , 0, 1, "C");
        $pdf->Line(10, 25, 250 - 50, 25);

        $pdf->SetFont('angsa', '', 15);

        $header = array(
            iconv('UTF-8', 'TIS-620', 'รหัสพนักงาน : ' . $row['user_code']) ,
            iconv('UTF-8', 'TIS-620', 'ชื่อ : ' . $row['user_name'] . '(' . $row['user_nick_name'] . ')') ,
            iconv('UTF-8', 'TIS-620', 'สาขา : ' . $row['branch_name']),
            iconv('UTF-8', 'TIS-620', 'แผนก : ' . $row['depart_name'])
        );
        foreach ($header as $col) $pdf->Cell(50, 10, $col, 0);
        $pdf->Ln();

        $pdf->Cell(0, 10, iconv('UTF-8', 'TIS-620', 'จากวันที่ ' . $_GET['fromdate'] . ' ถึงวันที่ ' . $_GET['todate']) , 0, 1, "C");
        
        



        $header = array(
            iconv('UTF-8', 'TIS-620', 'ลำดับ') ,
            iconv('UTF-8', 'TIS-620', 'วัน') ,
            iconv('UTF-8', 'TIS-620', 'วันที่') ,
            iconv('UTF-8', 'TIS-620', 'เวลาเข้างาน') ,
            iconv('UTF-8', 'TIS-620', 'เวลาออกงาน') ,
            iconv('UTF-8', 'TIS-620', 'สาย') ,
            iconv('UTF-8', 'TIS-620', 'โอที') ,
            iconv('UTF-8', 'TIS-620', 'ลา') ,
        );
        foreach ($header as $col) $pdf->Cell(24, 7, $col, 1);
        $pdf->Ln();


        

        while (strtotime($start_date) <= strtotime($end_date))
        {
            $pdf->Cell(24, 5, $i, 1);
            $pdf->Cell(24, 5, $start_date, 1);
            $eng_date1 = strtotime($start_date);
            $pdf->Cell(24, 5, iconv('UTF-8', 'TIS-620', thai_date($eng_date1)) , 1);

            try
            {
                $check_data = 0;
                $stmt = $conn->prepare("
     SELECT
DATE_FORMAT(worktime.worktime_date, '%Y-%m-%d') as worktime_date,
worktime.worktime_date as worktime_date_full,
user.user_name,
worktime.worktime_id,
worktime.worktime_in_time as IN_TIME,
worktime.worktime_out_time as OUT_TIME,
worktime.worktime_add_date,
depart.depart_name,
`user`.user_code,
DATE_FORMAT(  worktime.worktime_out_time, '%H:%i:%s') as worktime_out_time,
 DATE_FORMAT(  worktime.worktime_in_time, '%H:%i:%s') as worktime_in_time,
  `user`.user_salary_main_fee ,
   lm.leave_name,
   lm.leave_id,
   TIMEDIFF( worktime.worktime_out_time,DATE_FORMAT(worktime.worktime_date,'%Y-%m-%d 17:30:00')) AS Minutes
FROM
worktime
LEFT JOIN `user` ON `user`.user_id = worktime.worktime_user_id
LEFT JOIN depart ON `user`.user_depart_id = depart.depart_id
LEFT JOIN leave_log ON worktime.worktime_leave_log_id = leave_log.leave_log_id
LEFT JOIN `leave`  as lm ON leave_log.leave_log_leave_id = lm.leave_id 
LEFT JOIN employee_type ON `user`.user_employee_type_id = employee_type.employee_type_id 
where 1=1
AND depart.depart_id != '5'
AND worktime_user_id = :worktime_user_id
AND worktime_date = :worktime_date
AND worktime_active = :worktime_active


ORDER BY  worktime_date ASC

    ");

                $stmt->execute(['worktime_user_id' => $user_id_set, 'worktime_date' => $start_date, 'worktime_active' => 1,

                ]);

                foreach ($stmt as $row)
                {

                    $pdf->Cell(24, 5, $row['worktime_in_time'], 1);
                    $pdf->Cell(24, 5, $row['worktime_out_time'], 1);

                   

                    $user_salary_main_fee = $row['user_salary_main_fee'];

                   

                    $start = strtotime($row['worktime_in_time']);
                    $end = strtotime('08:00:00');
                    $work_in_late_time = ($start - $end) / 60;
                    $work_in_late_time = floor($work_in_late_time);

                    if ($work_in_late_time >= 1)
                    {
                        $work_in_late_time = $work_in_late_time . ' นาที';
                        $work_in_late_time_value = $work_in_late_time_value + $work_in_late_time;
                        $sum_late=$sum_late+1;

                    }
                    else
                    {
                        $work_in_late_time = '';
                    }



                    if ($row['Minutes']>"00:30:00") {

                        [$hours, $minutes] = explode(':', $row['Minutes']);
                        $minutes =  ((int)$hours * 60 + (int)$minutes )/60;
                        $minutes = floor($minutes * 2) / 2;
                        $minutes = number_format((float)$minutes, 2, '.', '') . " ชม.";
                        $sum_ot=$sum_ot+$minutes;


                    }else{
                         $minutes="";
                    }



                
                    $pdf->Cell(24, 5, iconv('UTF-8', 'TIS-620', $work_in_late_time) , 1);
                     $pdf->Cell(24, 5, iconv('UTF-8', 'TIS-620', $minutes) , 1);
                    // $pdf->Cell(24, 5, iconv('UTF-8', 'TIS-620', $work_out_ot_time) , 1);
                    $pdf->Cell(24, 5, iconv('UTF-8', 'TIS-620', $row['leave_name']) , 1);

                 
                    switch ($row['leave_id']) {
                        case '1':$sum_personal_leave=$sum_personal_leave+1;break;
                        case '2':$sum_personal_leave=$sum_personal_leave+0.5;break;
                        case '3':$sum_personal_leave=$sum_personal_leave+0.5;break;
                        case '4':$sum_sick_leave=$sum_sick_leave+1;break;
                        case '5':$sum_holiday_leave=$sum_holiday_leave+1;break;
                        case '6':$sum_sick_leave=$sum_sick_leave+0.5;break;
                        default :break;
                    }

                    $check_data = 1;

                }

                if ($check_data < 1)
                {
                    $pdf->Cell(24, 5, ' ', 1);
                    $pdf->Cell(24, 5, ' ', 1);
                    $pdf->Cell(24, 5, ' ', 1);
                    $pdf->Cell(24, 5, ' ', 1);
                    $pdf->Cell(24, 5, ' ', 1);
                }

            }
            catch(PDOException $e)
            {
                echo $e->getMessage();
            }


            $pdf->Ln();
            $i++;
            $start_date = date("Y-m-d", strtotime("+1 days", strtotime($start_date)));

        }
        $start_date = $_GET['fromdate'];

        //////////sum all//////////////


        $sum_all_leave=$sum_personal_leave;
         $pdf->Ln();

 $header = array(
            iconv('UTF-8', 'TIS-620', 'สาย(ครั้ง)') ,
            iconv('UTF-8', 'TIS-620', 'ผิดกฎ') ,
            iconv('UTF-8', 'TIS-620', 'ลากิจ') ,
            iconv('UTF-8', 'TIS-620', 'ขาดงาน') ,
            iconv('UTF-8', 'TIS-620', 'รวมหัก') ,
            iconv('UTF-8', 'TIS-620', 'ลาป่วย') ,
            iconv('UTF-8', 'TIS-620', 'ลาพักร้อน') ,
            iconv('UTF-8', 'TIS-620', 'OT(ชม.)') ,
        );
        foreach ($header as $col) $pdf->Cell(24, 7, $col,  1,0, 'C');
        $pdf->Ln();
         $header = array(
            iconv('UTF-8', 'TIS-620', $sum_late) ,
            iconv('UTF-8', 'TIS-620', '') ,
            iconv('UTF-8', 'TIS-620', $sum_personal_leave) ,
            iconv('UTF-8', 'TIS-620', '') ,
            iconv('UTF-8', 'TIS-620', $sum_all_leave) ,
            iconv('UTF-8', 'TIS-620', $sum_sick_leave) ,
            iconv('UTF-8', 'TIS-620', $sum_holiday_leave) ,
            iconv('UTF-8', 'TIS-620', $sum_ot) ,
        );
        foreach ($header as $col) $pdf->Cell(24, 7, $col, 1,0, 'C');
        
         $pdf->Ln();
          $pdf->Ln();
         //////////////sum all//////////////////

         $header = array(
            iconv('UTF-8', 'TIS-620', 'ลงชื่อพนักงาน') ,
            iconv('UTF-8', 'TIS-620', 'ลงชื่อหัวหน้างาน') ,
        );
        foreach ($header as $col) $pdf->Cell(30, 7, $col,  1,0, 'C');
         $pdf->Ln();
        $header = array(
            iconv('UTF-8', 'TIS-620', '') ,
            iconv('UTF-8', 'TIS-620', '') ,
        );
        foreach ($header as $col) $pdf->Cell(30, 20, $col,  1,0, 'C');


    }

}
catch(PDOException $e)
{
    echo $e->getMessage();
}







$pdf->Output("billing_note_1" . $nowdate . ".pdf", "F");
header('location: billing_note_1' . $nowdate . '.pdf');

exit();
?>
