<?php
include '../include/session.php'; 
$page='worktime_employee';
?>
<!DOCTYPE html>
<html lang="en">

<?php
    include '../include/header.php'; 
?>

<body id="page-top" style="font-family: 'Prompt', sans-serif;">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php include '../menu/side_menu.php'; ?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <?php include '../menu/topbar_menu.php'; ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">

                    <!-- Page Heading -->
                    <h1 class="h3 mb-2 text-gray-800">จัดการลงเวลางานพนักงาน</h1>
                    <p class="mb-4"></p>
                    <?php
                            if(isset($_SESSION['error'])){
                              echo "
                                <div class='alert alert-danger alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-warning'></i> Error!</h4>
                                  ".$_SESSION['error']."
                                </div>
                              ";
                              unset($_SESSION['error']);
                            }
                            if(isset($_SESSION['success'])){
                              echo "
                                <div class='alert alert-success alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-check'></i> Success!</h4>
                                  ".$_SESSION['success']."
                                </div>
                              ";
                              unset($_SESSION['success']);
                            }
                ?>
                    <!-- DataTales Example -->

                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">จัดการลงเวลางานพนักงาน</h6>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="container.php">

                                <div class="form-row">

                                    <div class="form-group col-md-2">
                                          <label for="fromdate">วันที่ :</label>
                                              
                                            <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['fromdate']!='') {
                                                  $fromdate=$_POST['fromdate'];
                                                }else{
                                                  $fromdate=date('Y-m-01',strtotime("-1 year"));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="fromdate" id="fromdate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $fromdate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#fromdate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                        <div class="form-group col-md-2">
                                          <label for="todate">ถึงวันที่ :</label>
                                              
                                             <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['todate']!='') {
                                                  $todate=$_POST['todate'];
                                                }else{
                                                $a_date = date('Y-m-01');
                                                  $todate=date("Y-m-t", strtotime($a_date));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="todate" id="todate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $todate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#todate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                    </div>    
                                    <center>    
                                    <button type="submit" class="btn btn-primary btn-sm   btn-flat " name="search"><i class="fa fa-search"></i> ค้นหา</button>

                                    <a  href="#" data-toggle="modal" data-target="#adduserModal">
                                    <button   class="btn btn-info btn-sm   btn-flat "><i class="fa fa-plus"></i> ลงเวลาทำงาน</button>
                                </a>

                                    

                                      

                                    </center>

                            </form>
                        </div>
                    </div>
                    <div class="card shadow mb-4">
                        
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0" style="font-size: 12px;" data-order='[[ 1, "desc" ]]'>
                                    <thead>
                                        <tr>
                                            <th>วันที่</th>
                                            <th>เวลาเข้างาน</th>
                                            <th>เวลาออกงาน</th>
                                            <th>เวลาทำงาน</th>
                                            <th>เวลาที่เกิน</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>วันที่</th>
                                            <th>เวลาเข้างาน</th>
                                            <th>เวลาออกงาน</th>
                                            <th>เวลาทำงาน</th>
                                            <th>เวลาที่เกิน</th>
                                        </tr>
                                    </tfoot>
                                    <tbody>
                                       
                                        <?php
                                                $conn = $pdo->open();
                                                try{
                                                  $stmt = $conn->prepare("
                                                        SELECT
DATE_FORMAT(worktime.worktime_date, '%Y-%m-%d') as worktime_date,
user.user_name,
worktime.worktime_id,
worktime.worktime_in_time as IN_TIME,
worktime.worktime_out_time as OUT_TIME,
worktime.worktime_add_date 
FROM
worktime
LEFT JOIN `user` ON `user`.user_id = worktime.worktime_user_id
where 1=1
AND worktime.worktime_add_date BETWEEN  :fromdate AND :todate  
AND worktime.worktime_user_id = :worktime_user_id
                                                          
                                                    ");
                                                  $stmt->execute([
                                                      'fromdate'=>$fromdate,
                                                      'todate'=>$todate,
                                                      'worktime_user_id'=>$_SESSION['user_id']
                                                  ]);
                                                foreach($stmt as $row){
                                                   
                                                   if ($row['OUT_TIME']<>"") {

                                                      $worktime = gmdate("H:i:s",(strtotime($row['OUT_TIME']) - strtotime($row['IN_TIME'])));

                                                      $aa = (strtotime($row['OUT_TIME'])) - (strtotime($row['IN_TIME']));

                                                      if ($aa>32400) {
                                                        $overtime = gmdate("H:i:s",((strtotime($row['OUT_TIME']) - strtotime($row['IN_TIME']))-32400));
                                                      }else{
                                                        $overtime = "";
                                                      }

                                                      $check_out = $row['OUT_TIME']." <button class='btn btn-info btn-sm  btn-flat view_check_out' data-id='".$row['worktime_id']."'><i class='fa fa-camera'></i></button>";

                                                   }else{
                                                    $worktime="";
                                                    $overtime = "";
                                                    $check_out ="<button class='btn btn-danger btn-sm  btn-flat check_out' data-id='".$row['worktime_id']."'>ออกงาน</button>";
                                                   }
                                                  



                                                  
                                                 
                        echo "
                          <tr>
                          <td >".$row['worktime_date']."</td> 
                          <td >".$row['IN_TIME']." <button class='btn btn-info btn-sm  btn-flat view_check_in' data-id='".$row['worktime_id']."'><i class='fa fa-camera'></i></button></td> 
                          <td >".$check_out."</td>
                          <td >".$worktime."</td> 
                          <td >".$overtime."</td> 

                          
                          </tr>
                        ";
                                                    }
                                                }
                                                catch(PDOException $e){
                                                  echo $e->getMessage();
                                                }
                                        ?>
                                       
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; THANAPHONG +66968232815</span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <?php include 'worktime_add_modal.php'; ?>  
    <?php include 'worktime_update_modal.php'; ?>    
    
    <?php include 'worktime_view_check_in_Modal.php'; ?>  
    <?php include 'worktime_view_check_out_Modal.php'; ?>  


    
    <?php include '../authen/logout_modal.php'; ?>
    <?php include '../include/script.php'; ?>
    


  <script>

            $(document).ready(function() {
    $('#dataTable_order').DataTable( {
        "order": [[ 0, "desc" ]]
    } );
} );

            


$(function(){
  


$(document).on('click', '.check_out', function(e){
    e.preventDefault();
    $('#check_outModal').modal('show');
    var id = $(this).data('id');
    getRow(id);
  });

$(document).on('click', '.view_check_in', function(e){
    e.preventDefault();
    $('#view_check_in_Modal').modal('show');
    var id = $(this).data('id');
    getRow(id);
  });

$(document).on('click', '.view_check_out', function(e){
    e.preventDefault();
    $('#view_check_out_Modal').modal('show');
    var id = $(this).data('id');
    getRow(id);
  });



});




function getRow(id){
  $.ajax({
    type: 'POST',
    url: 'worktime_row.php',
    data: {id:id},
    dataType: 'json',
    success: function(response){
      $('.id').val(response.worktime_id);
      $('.img_check_in').html(response.img_check_in);  
      $('.img_check_out').html(response.img_check_out);    
     




    }
  });




}


</script>


</body>

</html>