<?php


include '../include/session.php';
include '../../include/conn.php'; 


/**

 * PHPExcel

 *

 * Copyright (c) 2006 - 2015 PHPExcel

 *

 * This library is free software; you can redistribute it and/or

 * modify it under the terms of the GNU Lesser General Public

 * License as published by the Free Software Foundation; either

 * version 2.1 of the License, or (at your option) any later version.

 *

 * This library is distributed in the hope that it will be useful,

 * but WITHOUT ANY WARRANTY; without even the implied warranty of

 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU

 * Lesser General Public License for more details.

 *

 * You should have received a copy of the GNU Lesser General Public

 * License along with this library; if not, write to the Free Software

 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

 *

 * @category   PHPExcel

 * @package    PHPExcel

 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)

 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt    LGPL

 * @version    ##VERSION##, ##DATE##

 */



/** Error reporting */

error_reporting(E_ALL);

ini_set('display_errors', TRUE);

ini_set('display_startup_errors', TRUE);

date_default_timezone_set('Europe/London');



if (PHP_SAPI == 'cli')

    die('This example should only be run from a Web Browser');



/** Include PHPExcel */

require_once dirname(__FILE__) . '/../../include/excel/Classes/PHPExcel.php';





// Create new PHPExcel object

$objPHPExcel = new PHPExcel();



// Set document properties

$objPHPExcel->getProperties()->setCreator("REPORT_PICKING_PRODUCT")

                             ->setLastModifiedBy("REPORT_PICKING_PRODUCT")

                             ->setTitle("Office 2007 XLSX Test Document")

                             ->setSubject("Office 2007 XLSX Test Document")

                             ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")

                             ->setKeywords("office 2007 openxml php")

                             ->setCategory("Test result file");



$styleArray = array(

  'borders' => array(

    'allborders' => array(

      'style' => PHPExcel_Style_Border::BORDER_THIN

    )

  )

);




$objPHPExcel->setActiveSheetIndex(0);


$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'รายงานการซ่อมรถ'); 
$objPHPExcel->getActiveSheet()->mergeCells('A1:J1');

$objPHPExcel->getActiveSheet()->getStyle('A1:J1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle("A1:J1")->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getStyle("A1:J1")->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)

        ->getStartColor()

        ->setRGB('FFFF00');

$objPHPExcel->getActiveSheet()->getStyle('A2:B5')->applyFromArray($styleArray);



$objPHPExcel->getActiveSheet()->SetCellValue('A2', 'วันที่'); 
$objPHPExcel->getActiveSheet()->SetCellValue('A3', 'ถึงวันที่');


 $fromdate=date_format(date_create($_GET['fromdate']),"d/m/Y");
  $todate=date_format(date_create($_GET['todate']),"d/m/Y");

$objPHPExcel->getActiveSheet()->SetCellValue('B2', $fromdate." "); 
$objPHPExcel->getActiveSheet()->SetCellValue('B3', $todate." ");


$firstrow=6;
$objPHPExcel->getActiveSheet()->SetCellValue('A'.$firstrow, 'MT No.'); 

$objPHPExcel->getActiveSheet()->SetCellValue('B'.$firstrow, 'วันที่');

$objPHPExcel->getActiveSheet()->SetCellValue('C'.$firstrow, 'ทะเบียน');

$objPHPExcel->getActiveSheet()->SetCellValue('D'.$firstrow, 'เบอร์รถ');

$objPHPExcel->getActiveSheet()->SetCellValue('E'.$firstrow, 'ชื่อคนขับ');

$objPHPExcel->getActiveSheet()->SetCellValue('F'.$firstrow, 'อาการ');

$objPHPExcel->getActiveSheet()->SetCellValue('G'.$firstrow, 'ส่วนงาน');

$objPHPExcel->getActiveSheet()->SetCellValue('H'.$firstrow, 'รายละเอียดการซ่อม');

$objPHPExcel->getActiveSheet()->SetCellValue('I'.$firstrow, 'ช่าง');

$objPHPExcel->getActiveSheet()->SetCellValue('J'.$firstrow, 'หมายเหตุ');



$objPHPExcel->getActiveSheet()->getStyle("A".$firstrow.":J".$firstrow."")->getFont()->setBold(true);



$objPHPExcel->getActiveSheet()->getStyle('A'.$firstrow.':J'.$firstrow)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)

        ->getStartColor()

        ->setRGB('FFFF00');





if ($_GET["maintenance_depart_id"]!="") {
                                                            $filter1="AND maintenance_depart.maintenance_depart_id = ".$_GET["maintenance_depart_id"];
                                                        }else{
                                                            $filter1=""; 
                                                        }   

if ($_GET["vehicle_id"]!="") {
                                                            $filter2="AND maintenance_vehicle_id = ".$_GET["vehicle_id"];
                                                        }else{
                                                            $filter2=""; 
                                                        }   



                                                $conn = $pdo->open();
                                                try{
                                                  $stmt = $conn->prepare("
                                                   
SELECT
    maintenance.maintenance_id,
    maintenance.maintenance_no,
    maintenance.maintenance_plate_no,
    maintenance.maintenance_bus_no,
    maintenance.maintenance_broken_details,
    maintenance.maintenance_driver_name,
    maintenance.maintenance_parking_date,
    maintenance.maintenance_fix_details,
    maintenance.maintenance_technician_accept_name,
    maintenance.maintenance_remark,
    maintenance.maintenance_fix_completed_date,
    maintenance.maintenance_active,
    maintenance.maintenance_status,
    maintenance.maintenance_add_by,
    maintenance.maintenance_add_date,
    maintenance.maintenance_update_by,
    maintenance.maintenance_update_date,
    maintenance_status.maintenance_status_name,
    maintenance_status.maintenance_status_color,
    maintenance_list.maintenance_list_id,
    maintenance_list.maintenance_list_name,
    maintenance_depart.maintenance_depart_id,
    maintenance_depart.maintenance_depart_name,
    maintenance.maintenance_date,
    vehicle.vehicle_plate_no,
    vehicle.vehicle_no 
FROM
    maintenance
    LEFT JOIN maintenance_status ON maintenance.maintenance_status = maintenance_status.maintenance_status_id
    LEFT JOIN maintenance_depart ON maintenance.maintenance_depart_id = maintenance_depart.maintenance_depart_id
    LEFT JOIN maintenance_list ON maintenance.maintenance_list_id = maintenance_list.maintenance_list_id
    LEFT JOIN vehicle ON maintenance.maintenance_vehicle_id = vehicle.vehicle_id

 where 1=1
      AND  maintenance_add_date >= '".$_GET['fromdate']."'
      AND  maintenance_add_date <= '".$_GET['todate']."'
      ".$filter1."
".$filter2."    

                                                            ORDER BY
                                                            maintenance_id DESC

                                                    ");

                                                 $no=7;
                                                  $stmt->execute();
                                                foreach($stmt as $row){

                                                   $objPHPExcel->getActiveSheet()->SetCellValue('A'.$no, ($row['maintenance_no']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$no, ($row['maintenance_date']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$no, ($row['vehicle_plate_no']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$no, ($row['vehicle_no']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$no, ($row['maintenance_driver_name']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$no, ($row['maintenance_broken_details']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$no, ($row['maintenance_depart_name']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$no, ($row['maintenance_fix_details']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$no, ($row['maintenance_technician_accept_name']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$no, ($row['maintenance_remark']));
                                                    $no++;

                                                    }
                                                }
                                                catch(PDOException $e){
                                                  echo $e->getMessage();
                                                }





 $objPHPExcel->getActiveSheet()->getStyle('A6'.':J'.$no)->applyFromArray($styleArray);



foreach(range('A','J') as $columnID) {

    $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)

        ->setAutoSize(true);

}




$objWriter  =   new PHPExcel_Writer_Excel2007($objPHPExcel);







// Rename worksheet

$objPHPExcel->getActiveSheet()->setTitle('Simple');





// Set active sheet index to the first sheet, so Excel opens this as the first sheet

$objPHPExcel->setActiveSheetIndex(0);





// Redirect output to a client’s web browser (Excel2007)

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

header('Content-Disposition: attachment;filename="REPORT_PICKING_PRODUCT.xlsx"');

header('Cache-Control: max-age=0');

// If you're serving to IE 9, then the following may be needed

header('Cache-Control: max-age=1');



// If you're serving to IE over SSL, then the following may be needed

header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past

header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified

header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1

header ('Pragma: public'); // HTTP/1.0



$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

$objWriter->save('php://output');

exit;

