<?php



include '../include/session.php'; 

/**

 * PHPExcel

 *

 * Copyright (c) 2006 - 2015 PHPExcel

 *

 * This library is free software; you can redistribute it and/or

 * modify it under the terms of the GNU Lesser General Public

 * License as published by the Free Software Foundation; either

 * version 2.1 of the License, or (at your option) any later version.

 *

 * This library is distributed in the hope that it will be useful,

 * but WITHOUT ANY WARRANTY; without even the implied warranty of

 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU

 * Lesser General Public License for more details.

 *

 * You should have received a copy of the GNU Lesser General Public

 * License along with this library; if not, write to the Free Software

 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

 *

 * @category   PHPExcel

 * @package    PHPExcel

 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)

 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL

 * @version    ##VERSION##, ##DATE##

 */



/** Error reporting */

error_reporting(E_ALL);

ini_set('display_errors', TRUE);

ini_set('display_startup_errors', TRUE);

date_default_timezone_set('Europe/London');



if (PHP_SAPI == 'cli')

	die('This example should only be run from a Web Browser');



/** Include PHPExcel */

require_once dirname(__FILE__) . '/../../include/excel/Classes/PHPExcel.php';





// Create new PHPExcel object

$objPHPExcel = new PHPExcel();



// Set document properties

$objPHPExcel->getProperties()->setCreator("TTW LOGISTICT")

							 ->setLastModifiedBy("TTW LOGISTICT")

							 ->setTitle("Office 2007 XLSX Test Document")

							 ->setSubject("Office 2007 XLSX Test Document")

							 ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")

							 ->setKeywords("office 2007 openxml php")

							 ->setCategory("Test result file");



$objPHPExcel->setActiveSheetIndex(0);

$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'วันที่เข้าระบบ'); 

$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'container_no');

$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'order_no');

$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'order_customer_code');

$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'ชื่อสินค้า');

$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'ประเภท');

$objPHPExcel->getActiveSheet()->SetCellValue('G1', 'qty');

$objPHPExcel->getActiveSheet()->SetCellValue('H1', 'weight');

$objPHPExcel->getActiveSheet()->SetCellValue('I1', 'length');

$objPHPExcel->getActiveSheet()->SetCellValue('J1', 'width');

$objPHPExcel->getActiveSheet()->SetCellValue('K1', 'height');

$objPHPExcel->getActiveSheet()->SetCellValue('L1', 'cbm');

$objPHPExcel->getActiveSheet()->SetCellValue('M1', 'เมือง');

$objPHPExcel->getActiveSheet()->SetCellValue('N1', 'ราคาขาย');

$objPHPExcel->getActiveSheet()->SetCellValue('O1', 'ยอดชำระ');

$objPHPExcel->getActiveSheet()->SetCellValue('P1', 'ต้นทุน');

$objPHPExcel->getActiveSheet()->SetCellValue('Q1', 'ยอดรวมต้นทุน');

$objPHPExcel->getActiveSheet()->SetCellValue('R1', 'สถานะการส่งสินค้า');

$objPHPExcel->getActiveSheet()->SetCellValue('S1', 'สถานะการชำระเงิน');



$objPHPExcel->getActiveSheet()->getStyle("A1:S1")->getFont()->setBold(true);



$objPHPExcel->getActiveSheet()->getStyle('A1:S1')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)

        ->getStartColor()

        ->setRGB('FFFF00');



foreach(range('A','S') as $columnID) {

    $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)

        ->setAutoSize(true);

}





$fromdate=$_GET["fromdate"];

$todate=$_GET["todate"];

$container_no=$_GET["container_no"];

$order_no=$_GET["order_no"];

$order_customer_code=$_GET["order_customer_code"];





$conn = $pdo->open(); 

try{

$stmt = $conn->prepare("

	SELECT * 

	FROM orders 

	left JOIN container ON container.container_id = orders.order_container_id

	LEFT JOIN orders_status ON orders.order_status = orders_status.orders_status_id

    LEFT JOIN orders_bill_status ON orders_bill_status.orders_billing_status_id = orders.order_billing_status

	where 1=1

    AND orders.order_add_date BETWEEN  :fromdate AND :todate   

    AND container_no like CONCAT ('%',:container_no,'%')

    AND order_no like CONCAT ('%',:order_no,'%')

    AND order_customer_code like CONCAT ('%',:order_customer_code,'%')







	");

$stmt->execute([

    'fromdate'=>$fromdate,

    'todate'=>$todate,

    'container_no'=>$container_no,

    'order_no'=>$order_no,

    'order_customer_code'=>$order_customer_code



]);

$no=2;



foreach($stmt as $row){



	$date=date_create($row['order_add_date']);

	$order_add_date =  date_format($date,"Ymd");



	$objPHPExcel->getActiveSheet()->SetCellValue('A'.$no, ($order_add_date));

	$objPHPExcel->getActiveSheet()->SetCellValue('B'.$no, ($row['order_container_no']));

	$objPHPExcel->getActiveSheet()->SetCellValue('C'.$no, ($row['order_no']));

	$objPHPExcel->getActiveSheet()->SetCellValue('D'.$no, ($row['order_customer_code']));

	$objPHPExcel->getActiveSheet()->SetCellValue('E'.$no, ($row['order_product_name']));

	$objPHPExcel->getActiveSheet()->SetCellValue('F'.$no, ($row['order_product_type']));

	$objPHPExcel->getActiveSheet()->SetCellValue('G'.$no, ($row['order_product_qty']));

	$objPHPExcel->getActiveSheet()->SetCellValue('H'.$no, ($row['order_product_weight']));

	$objPHPExcel->getActiveSheet()->SetCellValue('I'.$no, ($row['order_product_length']));

	$objPHPExcel->getActiveSheet()->SetCellValue('J'.$no, ($row['order_product_width']));

	$objPHPExcel->getActiveSheet()->SetCellValue('K'.$no, ($row['order_product_height']));

	$objPHPExcel->getActiveSheet()->SetCellValue('L'.$no, ($row['order_product_cbm']));

	$objPHPExcel->getActiveSheet()->SetCellValue('M'.$no, ($row['container_from']));

	$objPHPExcel->getActiveSheet()->SetCellValue('N'.$no, ($row['order_product_price_per_cube']));

	$objPHPExcel->getActiveSheet()->SetCellValue('O'.$no, ($row['order_product_price']));

	$objPHPExcel->getActiveSheet()->SetCellValue('P'.$no, ($row['order_product_cost_per_cube']));

	$objPHPExcel->getActiveSheet()->SetCellValue('Q'.$no, ($row['order_product_cost']));

	$objPHPExcel->getActiveSheet()->SetCellValue('R'.$no, ($row['orders_status_name']));

	$objPHPExcel->getActiveSheet()->SetCellValue('S'.$no, ($row['orders_billing_status_name']));

	$no++;

}



$styleArray = array(

  'borders' => array(

    'allborders' => array(

      'style' => PHPExcel_Style_Border::BORDER_THIN

    )

  )

);



$objPHPExcel->getActiveSheet()->getStyle('A1:S'.($no-1))->applyFromArray($styleArray);

unset($styleArray);









}

catch(PDOException $e){

  echo $e->getMessage();

}





 





$objWriter  =   new PHPExcel_Writer_Excel2007($objPHPExcel);







// Rename worksheet

$objPHPExcel->getActiveSheet()->setTitle('Simple');





// Set active sheet index to the first sheet, so Excel opens this as the first sheet

$objPHPExcel->setActiveSheetIndex(0);





// Redirect output to a client’s web browser (Excel2007)

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

header('Content-Disposition: attachment;filename="ttw_order_report.xlsx"');

header('Cache-Control: max-age=0');

// If you're serving to IE 9, then the following may be needed

header('Cache-Control: max-age=1');



// If you're serving to IE over SSL, then the following may be needed

header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past

header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified

header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1

header ('Pragma: public'); // HTTP/1.0



$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

$objWriter->save('php://output');

exit;

