<?php


include '../include/session.php';
include '../../include/conn.php'; 


/**

 * PHPExcel

 *

 * Copyright (c) 2006 - 2015 PHPExcel

 *

 * This library is free software; you can redistribute it and/or

 * modify it under the terms of the GNU Lesser General Public

 * License as published by the Free Software Foundation; either

 * version 2.1 of the License, or (at your option) any later version.

 *

 * This library is distributed in the hope that it will be useful,

 * but WITHOUT ANY WARRANTY; without even the implied warranty of

 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU

 * Lesser General Public License for more details.

 *

 * You should have received a copy of the GNU Lesser General Public

 * License along with this library; if not, write to the Free Software

 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

 *

 * @category   PHPExcel

 * @package    PHPExcel

 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)

 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt    LGPL

 * @version    ##VERSION##, ##DATE##

 */



/** Error reporting */

error_reporting(E_ALL);

ini_set('display_errors', TRUE);

ini_set('display_startup_errors', TRUE);

date_default_timezone_set('Europe/London');



if (PHP_SAPI == 'cli')

    die('This example should only be run from a Web Browser');



/** Include PHPExcel */

require_once dirname(__FILE__) . '/../../include/excel/Classes/PHPExcel.php';





// Create new PHPExcel object

$objPHPExcel = new PHPExcel();



// Set document properties

$objPHPExcel->getProperties()->setCreator("REPORT_PICKING_PRODUCT")

                             ->setLastModifiedBy("REPORT_PICKING_PRODUCT")

                             ->setTitle("Office 2007 XLSX Test Document")

                             ->setSubject("Office 2007 XLSX Test Document")

                             ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")

                             ->setKeywords("office 2007 openxml php")

                             ->setCategory("Test result file");



$styleArray = array(

  'borders' => array(

    'allborders' => array(

      'style' => PHPExcel_Style_Border::BORDER_THIN

    )

  )

);




$objPHPExcel->setActiveSheetIndex(0);


$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'รายงานเบิกสินค้ารายชิ้น'); 
$objPHPExcel->getActiveSheet()->mergeCells('A1:K1');

$objPHPExcel->getActiveSheet()->getStyle('A1:K1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle("A1:K1")->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getStyle("A1:K1")->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)

        ->getStartColor()

        ->setRGB('FFFF00');

$objPHPExcel->getActiveSheet()->getStyle('A2:B5')->applyFromArray($styleArray);



$objPHPExcel->getActiveSheet()->SetCellValue('A2', 'วันที่'); 
$objPHPExcel->getActiveSheet()->SetCellValue('A3', 'ถึงวันที่');


 $fromdate=date_format(date_create($_GET['fromdate']),"d/m/Y");
  $todate=date_format(date_create($_GET['todate']),"d/m/Y");

$objPHPExcel->getActiveSheet()->SetCellValue('B2', $fromdate." "); 
$objPHPExcel->getActiveSheet()->SetCellValue('B3', $todate." ");


$firstrow=6;
$objPHPExcel->getActiveSheet()->SetCellValue('A'.$firstrow, 'Picking No.'); 

$objPHPExcel->getActiveSheet()->SetCellValue('B'.$firstrow, 'วันที่');

$objPHPExcel->getActiveSheet()->SetCellValue('C'.$firstrow, 'BU');

$objPHPExcel->getActiveSheet()->SetCellValue('D'.$firstrow, 'ทะเบียน');

$objPHPExcel->getActiveSheet()->SetCellValue('E'.$firstrow, 'ประเภทสินค้า');

$objPHPExcel->getActiveSheet()->SetCellValue('F'.$firstrow, 'กลุ่มสินค้า');

$objPHPExcel->getActiveSheet()->SetCellValue('G'.$firstrow, 'ชื่อสินค้า');


$objPHPExcel->getActiveSheet()->SetCellValue('H'.$firstrow, 'รหัสสินค้า');

$objPHPExcel->getActiveSheet()->SetCellValue('I'.$firstrow, 'เบอร์ยาง');

$objPHPExcel->getActiveSheet()->SetCellValue('J'.$firstrow, 'ประเภท');

$objPHPExcel->getActiveSheet()->SetCellValue('K'.$firstrow, 'ขนาด');

$objPHPExcel->getActiveSheet()->SetCellValue('L'.$firstrow, 'ยี่ห้อ');

$objPHPExcel->getActiveSheet()->SetCellValue('M'.$firstrow, 'ราคา');

$objPHPExcel->getActiveSheet()->SetCellValue('N'.$firstrow, 'ผู้ทำรายการ');

$objPHPExcel->getActiveSheet()->SetCellValue('O'.$firstrow, 'วันที่สร้าง');




$objPHPExcel->getActiveSheet()->getStyle("A".$firstrow.":O".$firstrow."")->getFont()->setBold(true);



$objPHPExcel->getActiveSheet()->getStyle('A'.$firstrow.':O'.$firstrow)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)

        ->getStartColor()

        ->setRGB('FFFF00');



foreach(range('A','O') as $columnID) {

    $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)

        ->setAutoSize(true);

}




if ($_GET['vehicle_id']!='') {
    $filter1="AND vehicle_id = '".$_GET['vehicle_id']."'";
}

if ($_GET['company_data_id']!='') {
    $filter2="AND company_data_id = '".$_GET['company_data_id']."'";
}






                                                $conn = $pdo->open();
                                                try{
                                                  $stmt = $conn->prepare("

SELECT
    pick.pick_no,
    pick.pick_date,
    pick.pick_vehicle_id,
    stock.stock_product_code,
    stock.stock_product_tire_no,
    stock_tire_brand.stock_tire_brand_name,
    stock_product_type.stock_product_type_name,
    stock_tire_rim.stock_tire_rim_size,
    vehicle.vehicle_plate_no,
    company_data.company_data_code,
    stock.stock_product_price,
    pick.pick_add_by,
    pick.pick_add_date,
    stock_product_group.stock_product_group_name,
    stock_tire_type.stock_tire_type_name,
    stock.stock_product_name 
FROM
    pick
    LEFT JOIN pick_detail ON pick.pick_id = pick_detail.pick_detail_pick_id
    LEFT JOIN stock ON pick_detail.pick_detail_stock_id = stock.stock_id
    LEFT JOIN stock_tire_brand ON stock.stock_product_tire_brand_id = stock_tire_brand.stock_tire_brand_id
    LEFT JOIN stock_product_type ON stock.stock_product_type_id = stock_product_type.stock_product_type_id
    LEFT JOIN stock_tire_rim ON stock.stock_product_tire_rim_id = stock_tire_rim.stock_tire_rim_id
    LEFT JOIN vehicle ON pick.pick_vehicle_id = vehicle.vehicle_id
    LEFT JOIN company_data ON vehicle.vehicle_company_id = company_data.company_data_id
    LEFT JOIN stock_product_group ON stock.stock_product_group_id = stock_product_group.stock_product_group_id
    LEFT JOIN stock_tire_type ON stock.stock_product_tire_type_id = stock_tire_type.stock_tire_type_id
                        
                                                    ");


                                                  
                                                 
                                                  $no=7;
                                                  $stmt->execute();
                                                foreach($stmt as $row){

                                                    $objPHPExcel->getActiveSheet()->SetCellValue('A'.$no, ($row['pick_no']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('B'.$no, ($row['pick_date']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('C'.$no, ($row['company_data_code']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('D'.$no, ($row['vehicle_plate_no']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('E'.$no, ($row['stock_product_type_name']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('F'.$no, ($row['stock_product_group_name']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('G'.$no, ($row['stock_product_name']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('H'.$no, ($row['stock_product_code']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('I'.$no, ($row['stock_product_tire_no']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('J'.$no, ($row['stock_tire_type_name']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('K'.$no, ($row['stock_tire_rim_size']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('L'.$no, ($row['stock_tire_brand_name']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('M'.$no, ($row['stock_product_price']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('N'.$no, ($row['pick_add_by']));
                                                    $objPHPExcel->getActiveSheet()->SetCellValue('O'.$no, ($row['pick_add_date']));

                                                    $no++;
                                                    }




$objPHPExcel->getActiveSheet()->getStyle('A6:O'.$no)->applyFromArray($styleArray);

unset($styleArray);



                                                }
                                                catch(PDOException $e){
                                                  echo $e->getMessage();
                                                }










 





$objWriter  =   new PHPExcel_Writer_Excel2007($objPHPExcel);







// Rename worksheet

$objPHPExcel->getActiveSheet()->setTitle('Simple');





// Set active sheet index to the first sheet, so Excel opens this as the first sheet

$objPHPExcel->setActiveSheetIndex(0);





// Redirect output to a client’s web browser (Excel2007)

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

header('Content-Disposition: attachment;filename="REPORT_PICKING_PRODUCT.xlsx"');

header('Cache-Control: max-age=0');

// If you're serving to IE 9, then the following may be needed

header('Cache-Control: max-age=1');



// If you're serving to IE over SSL, then the following may be needed

header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past

header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified

header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1

header ('Pragma: public'); // HTTP/1.0



$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

$objWriter->save('php://output');

exit;

