<?php
include '../include/session.php'; 
include '../../include/conn.php'; 
$page='employee';
$menu_id='17';
?>
<!DOCTYPE html>
<html lang="en">

<?php
    include '../include/header.php'; 
?>

<body id="page-top" style="font-family: 'Prompt', sans-serif;">

    <!-- Page Wrapper -->
    <div id="wrapper">

        <!-- Sidebar -->
        <?php include '../menu/side_menu.php'; ?>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <?php include '../menu/topbar_menu.php'; ?>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">

                    <!-- Page Heading -->
                    <h1 class="h3 mb-2 text-gray-800">รายงานพนักงานออก</h1>
                    <p class="mb-4"></p>
                    <?php
                            if(isset($_SESSION['error'])){
                              echo "
                                <div class='alert alert-danger alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-warning'></i> Error!</h4>
                                  ".$_SESSION['error']."
                                </div>
                              ";
                              unset($_SESSION['error']);
                            }
                            if(isset($_SESSION['success'])){
                              echo "
                                <div class='alert alert-success alert-dismissible'>
                                  <button type='button' class='close' data-dismiss='alert' aria-hidden='true'>&times;</button>
                                  <h4><i class='icon fa fa-check'></i> Success!</h4>
                                  ".$_SESSION['success']."
                                </div>
                              ";
                              unset($_SESSION['success']);
                            }
                ?>
                    <!-- DataTales Example -->

                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">รายงานพนักงานออก</h6>
                        </div>
                        <div class="card-body">
                            <form method="POST" action="user.php">

                                <div class="form-row">

                                    <div class="form-group col-md-2">
                                          <label for="fromdate">วันที่ :</label>
                                              
                                            <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['fromdate']!='') {
                                                  $fromdate=$_POST['fromdate'];
                                                }else{
                                                  $fromdate=date('Y-m-01',strtotime("-1 year"));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="fromdate" id="fromdate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $fromdate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#fromdate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                        <div class="form-group col-md-2">
                                          <label for="todate">ถึงวันที่ :</label>
                                              
                                             <?php
                                                date_default_timezone_set('Asia/Bangkok');
                                                if ($_POST['todate']!='') {
                                                  $todate=$_POST['todate'];
                                                }else{
                                                $a_date = date('Y-m-01');
                                                  $todate=date("Y-m-t", strtotime($a_date));
                                                }
                                            ?>
                                             <input type="text" class="form-control"  name="todate" id="todate" 
                                                placeholder="วันที่ปิดตู้"   value="<?php echo $todate;?>"  >
                                                  <script type="text/javascript">
                                                 jQuery('#todate').datetimepicker({
                                                    lang:'th',
                                                    timepicker:false,
                                                    format:'Y-m-d'
                                                 });
                                                 </script>
                                        </div>

                                    </div>    
                                    <center>    
                                    <button type="submit" class="btn btn-primary btn-user " name="search"><i class="fa fa-search"></i> ค้นหา</button>

                                   

                                    </center>

                            </form>
                        </div>
                    </div>
                    <div class="card shadow mb-4">
                        
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0" style="font-size: 12px;" data-order='[[ 1, "desc" ]]'>
                                    <thead>
                                        <tr>
                                          <th>#</th>
                                            <th>วันที่ทำรายการ</th>
                                            <th>รูปพนักงาน</th>
                                            <th>ชื่อพนักงาน</th>
                                            <th>แผนก/ตำแหน่ง</th>
                                            <th>วันที่ลาออก</th>
                                            <th>ประเภทการลาออก</th>
                                            <th>สาเหตุการลาออก</th>
                                        </tr>
                                    </thead>
                                   
                                    <tbody>
                                       
                                        <?php
                                                $conn = $pdo->open();
                                                try{
                                                  $stmt = $conn->prepare("
                                                   


SELECT
    user_resign_log.user_resign_log_id,
    user_resign_log.user_resign_log_user_id,
    user_resign_log.user_resign_log_date,
    user_resign_log.user_resign_log_type_id,
    user_resign_log.user_resign_log_remark,
    user_resign_log.user_resign_log_active,
    user_resign_log.user_resign_log_status,
    user_resign_log.user_resign_log_add_by,
    user_resign_log.user_resign_log_add_date,
    `user`.user_username,
    `user`.user_first_name,
    `user`.user_name,
    `user`.user_nick_name,
    `user`.user_position_name,
    depart.depart_name,
    user_resign_type.user_resign_type_name,
     CONCAT('<img width=100px src=../../app/file_upload/profile_img/',user_id,'/',user_id,'.jpg>') AS profile_img,
     user_profile_image_status_id
FROM
    user_resign_log
    LEFT JOIN `user` ON user_resign_log.user_resign_log_user_id = `user`.user_id
    LEFT JOIN depart ON `user`.user_depart_id = depart.depart_id
    LEFT JOIN user_resign_type ON user_resign_log.user_resign_log_type_id = user_resign_type.user_resign_type_id



                                                           
                                                    ");
                                                  $stmt->execute(['fromdate'=>$fromdate,'todate'=>$todate]);
                                                foreach($stmt as $row){

                                                    if ($row['user_resign_log_date']!='0000-00-00 00:00:00' and $row['user_resign_log_date']!='') {
                                                        $user_resign_log_date=date_create($row['user_resign_log_date']);
                                                        $user_resign_log_date=date_format($user_resign_log_date,"d/m/Y");
                                                    }else{
                                                        $user_resign_log_date='';
                                                    }


                                                     if ($row['user_profile_image_status_id']!=1) {
                                                        $user_profile_image_status_id="<a class='badge badge-danger'>ไม่พบรูป</a>";
                                                    }else{
                                                        $user_profile_image_status_id=$row['profile_img'];
                                                    }


                                                  
                                                    echo "
                                                          <tr>
                                                          <td >".$row['user_resign_log_id']."</td>
                                                          <td >".$row['user_resign_log_add_date']."</td>
                                                          <td >".$user_profile_image_status_id."</td>
                                                          <td >".$row['user_name']."/".$row['user_nick_name']."</td>
                                                          <td >".$row['depart_name']."/".$row['user_position_name']."</td>
                                                          <td >".$user_resign_log_date."</td> 
                                                          <td >".$row['user_resign_type_name']."</td> 
                                                          <td >".$row['user_resign_log_remark']."</td> 
                                                          

                                                          

                                                          </tr>
                                                        ";
                                                    }
                                                }
                                                catch(PDOException $e){
                                                  echo $e->getMessage();
                                                }
                                        ?>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
                <!-- /.container-fluid -->

            </div>
            <!-- End of Main Content -->

            <!-- Footer -->
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; THANAPHONG +66968232815</span>
                    </div>
                </div>
            </footer>
            <!-- End of Footer -->

        </div>
        <!-- End of Content Wrapper -->

    </div>
    <!-- End of Page Wrapper -->

    <!-- Scroll to Top Button-->
    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <?php include 'user_add_modal.php'; ?>
    <?php include 'user_delete_modal.php'; ?>    
    <?php include 'user_edit_modal.php'; ?> 
    <?php include '../authen/logout_modal.php'; ?>
    <?php include '../include/script.php'; ?>
    


    <script>
$(function(){
  

  $(document).on('click', '.delete', function(e){
    e.preventDefault();
    $('#deleteuserModal').modal('show');
    var id = $(this).data('id');
    getRow(id);
  });

$(document).on('click', '.edit', function(e){
    e.preventDefault();
    $('#edituserModal').modal('show');
    var id = $(this).data('id');
    getRowEdit(id);
  });

});

function getRow(id){
  $.ajax({
    type: 'POST',
    url: 'user_row.php',
    data: {id:id},
    dataType: 'json',
    success: function(response){
      $('.id').val(response.user_id);
      $('.name').html(response.user_name);

      
  
      $('#user_unactive_selected').val(response.user_active).html(response.user_active_value);


    }
  });




}

function getRowEdit(id){
  $.ajax({
    type: 'POST',
    url: 'user_row_edit.php',
    data: {id:id},
    dataType: 'json',
    success: function(response){
      $('#user_id_edit').val(response.user_id);
      $('.name').html(response.user_name);

      $('#user_code_edit').val(response.user_code);
      $('#user_name_edit').val(response.user_name);
      $('#user_nick_name_edit').val(response.user_nick_name);
      $('#user_address_edit').val(response.user_address);
      $('#user_tel_edit').val(response.user_tel);
      $('#user_work_start_date_edit').val(response.user_work_start_date);
      $('#user_birthday_date_edit').val(response.user_birthday_date);
      $('#user_username_edit').val(response.user_username);
      $('#user_password_edit').val(response.user_password);

      $('#user_depart_id_selected').val(response.depart_id).html(response.depart_name);
      $('#user_position_name_edit').val(response.user_position_name);

      $('#employee_type_id_selected').val(response.employee_type_id).html(response.employee_type_name);
      $('#active_id_selected').val(response.user_active).html(response.user_active_value);
   
      $('.employee_img_preview_edit').html(response.profile_img);  
      $('.employee_img_idcard_preview_edit').html(response.idcard_img);  
  
      $('#user_first_name_edit').val(response.user_first_name);
      $('#user_last_name_edit').val(response.user_last_name);
      $('#user_tax_id_edit').val(response.user_tax_id);


      
  
     $('#user_resign_date_edit').val(response.user_resign_date);

     $('#user_holliday_amount_edit').val(response.user_holliday_amount);




    }
  });




}
</script>


</body>

</html>