<?php



include '../include/session.php'; 

/**

 * PHPExcel

 *

 * Copyright (c) 2006 - 2015 PHPExcel

 *

 * This library is free software; you can redistribute it and/or

 * modify it under the terms of the GNU Lesser General Public

 * License as published by the Free Software Foundation; either

 * version 2.1 of the License, or (at your option) any later version.

 *

 * This library is distributed in the hope that it will be useful,

 * but WITHOUT ANY WARRANTY; without even the implied warranty of

 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU

 * Lesser General Public License for more details.

 *

 * You should have received a copy of the GNU Lesser General Public

 * License along with this library; if not, write to the Free Software

 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

 *

 * @category   PHPExcel

 * @package    PHPExcel

 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)

 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL

 * @version    ##VERSION##, ##DATE##

 */



/** Error reporting */

error_reporting(E_ALL);

ini_set('display_errors', TRUE);

ini_set('display_startup_errors', TRUE);

date_default_timezone_set('Europe/London');



if (PHP_SAPI == 'cli')

	die('This example should only be run from a Web Browser');



/** Include PHPExcel */

require_once dirname(__FILE__) . '/../../include/excel/Classes/PHPExcel.php';





// Create new PHPExcel object

$objPHPExcel = new PHPExcel();



// Set document properties

$objPHPExcel->getProperties()->setCreator("TTW LOGISTICT")

							 ->setLastModifiedBy("TTW LOGISTICT")

							 ->setTitle("Office 2007 XLSX Test Document")

							 ->setSubject("Office 2007 XLSX Test Document")

							 ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")

							 ->setKeywords("office 2007 openxml php")

							 ->setCategory("Test result file");



$objPHPExcel->setActiveSheetIndex(0);

$objPHPExcel->getActiveSheet()->SetCellValue('A1', 'วันที่'); 

$objPHPExcel->getActiveSheet()->SetCellValue('B1', 'ชื่อพนักงาน');

$objPHPExcel->getActiveSheet()->SetCellValue('C1', 'เวลาเข้างาน');

$objPHPExcel->getActiveSheet()->SetCellValue('D1', 'เวลาออกงาน');

$objPHPExcel->getActiveSheet()->SetCellValue('E1', 'เวลาทำงาน');

$objPHPExcel->getActiveSheet()->SetCellValue('F1', 'ล่วงเวลา');





$objPHPExcel->getActiveSheet()->getStyle("A1:F1")->getFont()->setBold(true);



$objPHPExcel->getActiveSheet()->getStyle('A1:F1')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)

        ->getStartColor()

        ->setRGB('FFFF00');



foreach(range('A','F') as $columnID) {

    $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)

        ->setAutoSize(true);

}





$fromdate=$_GET["fromdate"];

$todate=$_GET["todate"];







$conn = $pdo->open(); 

try{

$stmt = $conn->prepare("

	  SELECT

DATE_FORMAT(worktime.worktime_add_date, '%Y-%m-%d') as datea,

user.user_name,

worktime.worktime_in_time as IN_TIME,

worktime.worktime_out_time as OUT_TIME,

worktime.worktime_add_date 

FROM

worktime

INNER JOIN `user` ON `user`.user_id = worktime.worktime_user_id

where 1=1

    AND worktime.worktime_add_date BETWEEN  :fromdate AND :todate  

   





	");

$stmt->execute([

'fromdate'=>$fromdate,

    'todate'=>$todate    



]);

$no=2;



foreach($stmt as $row){



	$date=date_create($row['IN_TIME']);

	$order_add_date =  date_format($date,"Ymd");



	$worktime = gmdate("H:i:s",(strtotime($row['OUT_TIME']) - strtotime($row['IN_TIME'])));

    $aa = (strtotime($row['OUT_TIME'])) - (strtotime($row['IN_TIME']));

    if ($aa>32400) {

      $overtime = gmdate("H:i:s",((strtotime($row['OUT_TIME']) - strtotime($row['IN_TIME']))-32400));

    }else{

      $overtime = "";

    }





	$objPHPExcel->getActiveSheet()->SetCellValue('A'.$no, ($order_add_date));

	$objPHPExcel->getActiveSheet()->SetCellValue('B'.$no, ($row['user_name']));

	$objPHPExcel->getActiveSheet()->SetCellValue('C'.$no, ($row['IN_TIME']));

	$objPHPExcel->getActiveSheet()->SetCellValue('D'.$no, ($row['OUT_TIME']));

	$objPHPExcel->getActiveSheet()->SetCellValue('E'.$no, ($worktime));

	$objPHPExcel->getActiveSheet()->SetCellValue('F'.$no, ($overtime));



	$no++;

}



$styleArray = array(

  'borders' => array(

    'allborders' => array(

      'style' => PHPExcel_Style_Border::BORDER_THIN

    )

  )

);



$objPHPExcel->getActiveSheet()->getStyle('A1:F'.($no-1))->applyFromArray($styleArray);

unset($styleArray);









}

catch(PDOException $e){

  echo $e->getMessage();

}





 





$objWriter  =   new PHPExcel_Writer_Excel2007($objPHPExcel);







// Rename worksheet

$objPHPExcel->getActiveSheet()->setTitle('Simple');





// Set active sheet index to the first sheet, so Excel opens this as the first sheet

$objPHPExcel->setActiveSheetIndex(0);





// Redirect output to a client’s web browser (Excel2007)

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

header('Content-Disposition: attachment;filename="ttw_order_report.xlsx"');

header('Cache-Control: max-age=0');

// If you're serving to IE 9, then the following may be needed

header('Cache-Control: max-age=1');



// If you're serving to IE over SSL, then the following may be needed

header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past

header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified

header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1

header ('Pragma: public'); // HTTP/1.0



$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

$objWriter->save('php://output');

exit;

